package com.elitescloud.cloudt.security.common;

import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 系统内置用户.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/14
 */
public enum InnerUserEnum {
    // 系统管理员
    ADMIN(1L, "admin", "系统管理员");

    /**
     * 账号ID
     */
    private final Long id;

    /**
     * 登录账号
     */
    private final String username;
    /**
     * 显示名称
     */
    private final String displayName;

    InnerUserEnum(Long id, String username, String displayName) {
        this.id = id;
        this.username = username;
        this.displayName = displayName;
    }

    public Long getId() {
        return id;
    }

    public String getUsername() {
        return username;
    }

    public String getDisplayName() {
        return displayName;
    }

    private static final Map<String, InnerUserEnum> USER_MAP = Arrays.stream(InnerUserEnum.values())
            .collect(Collectors.toMap(InnerUserEnum::getUsername, t -> t, (t1, t2) -> t1));

    public static InnerUserEnum parse(String username) {
        if (!StringUtils.hasText(username)) {
            return null;
        }
        return USER_MAP.get(username);
    }
}
