package com.elitescloud.cloudt.core.provider;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.IdFactory;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;

import java.io.Serializable;

/**
 * 适用于JPA的基于Snowflake算法的ID生成器
 *
 * @author Moz
 * 3/17/2020
 */
@Slf4j
public class IdGenerator implements IdentifierGenerator {

    @Override
    public Serializable generate(SharedSessionContractImplementor sharedSessionContractImplementor, Object o) throws HibernateException {
        if (o instanceof BaseModel) {
            var id = ((BaseModel)o).getId();
            if (id != null) {
                return id;
            }
        }
        return IdFactory.generate();
    }

    /**
     * 生成ID
     *
     * @return ID
     */
    public static Serializable generate() {
        return IdFactory.generate();
    }


    /**
     * 生成ID
     *
     * @return ID
     */
    public static Long generateLong() {
        return IdFactory.generateLong();
    }
}
