package com.elitescloud.cloudt.system.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 组织的基本信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/30
 */
@Data
public class SysOrgBasicDTO implements Serializable {
    private static final long serialVersionUID = -1731468184547026986L;

    /**
     * 组织ID
     */
    private Long id;

    /**
     * 组织编码
     */
    private String code;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 上级组织ID
     */
    private Long parentId;

    /**
     * 上级组织编码
     */
    private String parentCode;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 类型
     */
    private String type;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 所属公司
     */
    private Long ouId;

    /**
     * 备注
     */
    private String remark;

    public String getPrettyName() {
        if (shortName == null || shortName.trim().length() == 0) {
            return name;
        }
        return shortName;
    }

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysOrgBasicDTO) {
            SysOrgBasicDTO the = (SysOrgBasicDTO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
