/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.base;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.MDC;

public abstract class AbstractLogTraceHandler {
    private final String traceIdPrefix;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    protected AbstractLogTraceHandler(String traceIdPrefix) {
        this.traceIdPrefix = traceIdPrefix;
    }

    protected String putTraceId() {
        return this.putTraceId(null);
    }

    protected String putTraceId(String traceId) {
        if (traceId == null || ((String)traceId).trim().isEmpty()) {
            LocalDateTime now = LocalDateTime.now();
            traceId = this.traceIdPrefix + "." + FORMATTER.format(now);
        }
        MDC.put((String)"cloudt_traceId", (String)traceId);
        return traceId;
    }
}

