package com.elitescloud.boot;

import com.elitescloud.boot.support.CloudtHttpMessagesConverters;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jsonb.JsonbAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.HttpMessageConverter;

import java.util.stream.Collectors;

/**
 * 信息转换器自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/18
 */
@AutoConfigureBefore(HttpMessageConvertersAutoConfiguration.class)
@AutoConfigureAfter({GsonAutoConfiguration.class, JacksonAutoConfiguration.class, JsonbAutoConfiguration.class})
class CloudtMessageConvertersAutoConfiguration {

    @Bean
    public HttpMessageConverters cloudtHttpMessageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new CloudtHttpMessagesConverters(converters.orderedStream().collect(Collectors.toList()));
    }
}
