package com.elitescloud.cloudt.context.util;

import cn.hutool.core.text.CharSequenceUtil;
import org.springframework.util.StringUtils;

/**
 * 脱敏工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/22
 */
public class DesensitizeUtil {

    private DesensitizeUtil() {
    }

    /**
     * 密码
     * <p>
     * 如******
     *
     * @param password 密码
     * @return 密码
     */
    public static String password(String password) {
        if (!StringUtils.hasText(password)) {
            return password;
        }

        return "******";
    }

    /**
     * 手机号处理
     * <p>
     * 如135****4748
     *
     * @param mobile 手机号
     * @return 手机号
     */
    public static String mobile(String mobile) {
        if (!StringUtils.hasText(mobile) || mobile.length() < 8) {
            return username(mobile);
        }

        return CharSequenceUtil.hide(mobile, 3, mobile.length() - 4);
    }

    /**
     * 电话号处理
     *
     * @param phone 电话号
     * @return 电话号
     */
    public static String phone(String phone) {
        if (!StringUtils.hasText(phone) || phone.length() < 7) {
            return username(phone);
        }

        return CharSequenceUtil.hide(phone, 4, phone.length() - 2);
    }

    /**
     * 邮箱处理
     *
     * @param email 邮箱
     * @return 电话号
     */
    public static String email(String email) {
        if (!StringUtils.hasText(email) || email.length() < 2) {
            return email;
        }

        int index = email.indexOf("@");
        if (index <= 1) {
            return email;
        }

        int startIndex = email.substring(0, index).length() > 3 ? 3 : 1;
        return CharSequenceUtil.hide(email, startIndex, index);
    }

    /**
     * 用户名称
     *
     * @param name 用户名
     * @return 用户名
     */
    public static String username(String name) {
        if (!StringUtils.hasText(name)) {
            return name;
        }

        int len = name.length();

        if (len == 1) {
            return name;
        }

        if (len == 2) {
            return name.charAt(0) + "*";
        }

        return CharSequenceUtil.hide(name, 1, len - 1);
    }

    /**
     * 用户ID
     *
     * @param userId 用户ID
     * @return 用户ID
     */
    public static String userId(Object userId) {
        if (userId == null) {
            return "";
        }
        return "***";
    }

    /**
     * 身份证号
     *
     * @param idCard 身份证号
     * @return 身份证号
     */
    public static String idCard(String idCard) {
        if (!StringUtils.hasText(idCard) || idCard.length() < 8) {
            return username(idCard);
        }

        return CharSequenceUtil.hide(idCard, 3, idCard.length() - 4);
    }

    /**
     * 银行卡号
     *
     * @param bankCard 银行卡号
     * @return 银行卡号
     */
    public static String bankCard(String bankCard) {
        if (!StringUtils.hasText(bankCard) || bankCard.length() < 9) {
            return username(bankCard);
        }

        return CharSequenceUtil.hide(bankCard, 4, bankCard.length() - 4);
    }
}
