package com.elitescloud.cloudt.core.annotation.common;

/**
 * 租户数据隔离类型.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/15
 */
public enum TenantIsolateType {

    /**
     * 使用默认的schema
     */
    DEFAULT("默认"),
    /**
     * 该策略下租户管理员及其用户使用租户自己的schema，其他用户使用默认的schema
     */
    TENANT("租户"),
    /**
     * 该策略下租户下的用户（除租户管理员）使用租户自己的schema，其他用户使用默认的schema
     */
    TENANT_USER("租户用户"),
    ;

    /**
     * 描述
     */
    private final String description;

    TenantIsolateType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }
}
