package com.elitescloud.cloudt.common.base;

/**
 * REST API 响应码
 *
 * @author Michael Li
 * @date 2018-11-08
 */
public enum ApiCode {
    /**
     * Http response entity status code, corresponding to HTTP Status Code
     */
    SUCCESS(200, "操作成功"),
    REDIRECT(302, "重定向"),
    BAD_REQUEST(400, "请求有误"),
    PARAMETER_PARSE_EXCEPTION(400001, "请求参数解析异常"),
    PARAMETER_EXCEPTION(400002, "请求参数校验异常"),
    AUTHENTICATION_EXCEPTION(400003, "认证授权异常"),
    VALIDATE_FAILED(400004, "参数校验失败"),
    UNAUTHORIZED(401, "未登录或token已经过期"),
    NOT_PERMISSION(403, "没有权限"),
    NOT_FOUND(404, "你请求的资源不存在"),
    NOT_FOUND_DATA(404001, "数据不存在"),
    METHOD_NOT_SUPPORT(405, "请求方式不支持"),
    NOT_ACCEPTABLE(406, "无法接收的数据类型"),
    REQUEST_ENTITY_TOO_LARGE(413, "请求体过大"),
    REQUEST_URL_TOO_LONG(414, "请求路径过长"),
    UNSUPPORTED_MEDIA_TYPE(415, "不支持的格式"),
    REQUEST_TOO_MANY(429, "请求太过频繁"),
    FAIL(500, "操作失败"),
    NOT_IMPLEMENTED(501, "未实现"),
    SYSTEM_EXCEPTION(500001, "系统异常"),
    DATABASE_EXCEPTION(500002, "数据库访问异常"),
    ELASTICSEARCH_EXCEPTION(500003, "Elasticsearch访问异常"),
    SYSTEM_BUSY(503, "服务器正忙"),
    VISITOR_TOO_MANY(503001, "访问用户过多"),
    THREAD_POOL_OVERFLOW(503002, "线程池溢出"),
    NO_PROVIDER(503003, "没有有效的服务提供者"),
    PROVIDER_EXCEPTION(503004, "服务提供者异常"),
    GATEWAY_TIMEOUT(504, "网关超时"),
    REQUEST_TIMEOUT(504001, "请求超时"),
    BUSINESS_EXCEPTION(900, "业务处理异常");


    private final int code;
    private final String msg;

    ApiCode(final int code, final String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static ApiCode getApiCode(int code) {
        ApiCode[] ecs = ApiCode.values();
        for (ApiCode ec : ecs) {
            if (ec.getCode() == code) {
                return ec;
            }
        }
        return SUCCESS;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getMsgFriendly() {
        switch (this) {
            case SUCCESS:
                return SUCCESS.getMsg();
            case UNAUTHORIZED:
                return "暂未登录或认证已过期，请重新登录";
            case NOT_PERMISSION:
                return "没有权限";
            case NOT_FOUND:
            case NOT_FOUND_DATA:
                return "数据不存在";
            case PARAMETER_PARSE_EXCEPTION:
                return "数据格式不正确";
            default:
                return this == SYSTEM_EXCEPTION ? null : getMsg();
        }
    }

}
