package com.elitescloud.cloudt.common.annotation;

import java.lang.annotation.*;

/**
 * udc字段
 * <p>
 * 注解在待翻译的udc字段上，如
 * <pre>
 *     {@code
 *       @SysCode(sys = Application.name, mod = "employeeType")
 *       private String type;
 *
 *       private String typeName;
 *     }
 * </pre>
 *
 * @author Michael Li
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SysCode {
    /**
     * 领域码（应用编码）
     * <p>
     * 默认取当前应用编码，建议直接指定为固定的常量值，避免因系统融合时应用名称变化而取不到正确的应用名称
     *
     * @return 领域
     */
    String sys() default "";

    /**
     * UDC编码
     *
     * @return UDC编码
     */
    String mod();

    /**
     * 翻译后赋值的字段
     * <p>
     * 默认是udc值字段 + Name，如udc值编码字段名称是type，则默认名称字段为typeName
     *
     * @return 字段名称
     */
    String nameField() default "";
}
