package com.elitescloud.cloudt.common.base.annotation.webservice;

import java.lang.annotation.*;

/**
 * WebService消费者.
 *
 * @author Kaiser（wang shao）
 * 2022/8/11
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface WebServiceConsumer {

    /**
     * 服务端是否是java应用
     * <p>
     * 如果服务端是java开发，则将使用静态代理，否则使用动态代理，动态代理性能低于静态代理
     *
     * @return 服务端是否是java
     */
    boolean javaServer() default true;

    /**
     * bean名称
     *
     * @return bean名称
     */
    String beanName() default "";

    /**
     * 服务地址
     * <p>
     * 服务的完整地址，如http://wangs.com/services/order，与{@link #addressKey()}至少一个有效
     *
     * @return 服务地址
     */
    String address() default "";

    /**
     * 服务地址的配置key
     * <p>
     * 支持服务地址在配置文件中配置，支持不同的环境不同的地址，创建时从配置文件中取值
     *
     * @return 配置key
     */
    String addressKey() default "";
}
