package com.elitescloud.cloudt.platform.config;

import com.elitescloud.cloudt.core.common.BaseSwaggerConfig;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
public class PlatformSwaggerConfig extends BaseSwaggerConfig {

    public PlatformSwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        super(openApiExtensionResolver, serverProperties);
    }

    @Bean
    public Docket createPlatformServiceApi() {
        return createDocket("PlatformManagementAPI", "com.elitescloud.cloudt.platform.controller");
    }
}
