package com.elitescloud.cloudt.platform.model.entity;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * api权限配置
 * @author chen
 */
@Entity
@Table(name =  TableNameConstant.SYS_PLATFORM_API_PERMISSION, indexes = {
        @Index(name = "idx_api_appcode", columnList = "appCode"),
        @Index(name = "idx_api_permissioncode", columnList = "permissonCode", unique = true),
})
@org.hibernate.annotations.Table(appliesTo =  TableNameConstant.SYS_PLATFORM_API_PERMISSION, comment = "api权限配置")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value =  TableNameConstant.SYS_PLATFORM_API_PERMISSION, description = "api权限配置")
public class SysPlatformApiPermissionDO extends BaseModel implements Serializable {
    @Column
    @Comment("应用编码")
    String appCode;

    @ApiModelProperty("菜单编码")
    @Comment("菜单编码")
    @Column
    String menusCode;

    @ApiModelProperty("权限路径")
    @Comment("权限路径")
    @Column
    String permissonPath;

    @ApiModelProperty("权限名称")
    @Comment("权限名称")
    @Column
    String permissonName;

    @ApiModelProperty("权限编码")
    @Comment("权限编码")
    @Column
    String permissonCode;

    @ApiModelProperty("请求类型")
    @Comment("请求类型")
    @Column
    String requestType;

    @ApiModelProperty("描述")
    @Comment("描述")
    @Column
    String permissonDescribe;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformApiPermissionDO that = (SysPlatformApiPermissionDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
