package com.elitescloud.cloudt.platform.model.entity;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * 租户应用表
 */
@Entity
@Table(name = "sys_platform_tenant_app")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_tenant_app", comment = "租户应用表")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = "sys_platform_tenant_app", description = "租户应用表")
public class SysPlatformTenantAppDO extends BaseModel implements Serializable {
    @ApiModelProperty("租户编码")
    @Comment("租户编码")
    @Column
    String tenantCode;

    @ApiModelProperty("应用编码")
    @Comment("应用编码")
    @Column
    String appCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformTenantAppDO that = (SysPlatformTenantAppDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
