package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.Objects;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Entity
@Table(name = "sys_platform_udc_value"
        ,uniqueConstraints = @UniqueConstraint(columnNames= {"appCode","udcCode","udcValueCode", "tenantId"}))
@org.hibernate.annotations.Table(appliesTo = "sys_platform_udc_value", comment = "udc值")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = "sys_platform_udc_value", description = "udc值")
public class SysPlatformUdcValueDO extends BaseModel implements Serializable {
    @ApiModelProperty("应用编码")
    @Comment("应用编码")
    @Column()
    private String appCode;

    @ApiModelProperty("udc编码")
    @Comment("udc编码")
    @Column()
    private String udcCode;

    @ApiModelProperty("值编码")
    @Comment("值编码")
    @Column()
    private String udcValueCode;

    @ApiModelProperty("值名称")
    @Comment("值名称")
    @Column
    private String udcValueName;

    @ApiModelProperty("排序")
    @Comment(value = "排序", defaultValue = "1")
    @Column()
    private Integer udcOrder;

    @ApiModelProperty("是否启用")
    @Comment(value = "是否启用", defaultValue = "1")
    @Column(name = "allow_start")
    private Boolean allowStart;

    @ApiModelProperty("描述")
    @Comment("描述")
    @Column
    private String udcValueDescribe;

    @ApiModelProperty("是否内置")
    @Comment(value = "是否内置", defaultValue = "1")
    @Column(name = "allow_default")
    private Boolean allowDefault;

    @Comment("上级值编码")
    @Column()
    private String parentUdcValueCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformUdcValueDO that = (SysPlatformUdcValueDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}

