package com.elitescloud.cloudt.platform.model.params.menus;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.20
 **/
@Data
public class AddMenusParam implements Serializable {
    @ApiModelProperty("菜单归属应用")
            @NotBlank
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    @NotBlank
    String menusName;

    @ApiModelProperty("菜单类型 业务-系统")
    PlatformAppMenusTypeEnum menusType;

    @ApiModelProperty("菜单编码")
    @NotBlank
    String menusCode;

    @ApiModelProperty("排序")
    Integer menusOrder;

    @ApiModelProperty("上级菜单编码")
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    String menusRoute;

    @ApiModelProperty("描述")
    String menusDescribe;

    @ApiModelProperty("图标")
    String menusIcon;

    @ApiModelProperty("是否展示")
    Boolean display;

}
