package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "sys_platform_menus", description = "平台菜单表")
public class SysPlatformMenusVO extends BaseModel implements Serializable {
    @ApiModelProperty("菜单归属应用")
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    String menusName;

    @ApiModelProperty("菜单类型")
    String menusType;
    @ApiModelProperty("节点类型 菜单,按钮")
    String nodeType;

    @ApiModelProperty("菜单编码")
    String menusCode;

    @ApiModelProperty("排序")
    Integer menusOrder;

    @ApiModelProperty("菜单状态")
    Boolean menusState;

    @ApiModelProperty("上级菜单编码")
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    String menusRoute;

    @ApiModelProperty("描述")
    String menusDescribe;

    @ApiModelProperty("图标")
    String menusIcon;

    @ApiModelProperty("是否展示")
    Boolean display;
}
