package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.cloudt.platform.model.constant.SysPlatformSettingGroupEnum;
import com.elitescloud.cloudt.platform.model.constant.SysPlatformSettingTypeEnum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <pre>
 *     系统配置表
 * </pre>
 *
 * @author Michael Li
 * 2020-06-15
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "系统配置表", description = "系统配置表")
public class SysPlatformSettingVO implements Serializable {

    private static final long serialVersionUID = -7840804475330315230L;

    @ApiModelProperty(value = "设置的编号")
    private String settingNo;
    @ApiModelProperty(value = "设置名称")
    private String settingName;
    @ApiModelProperty(value = "设置类型 系统,业务")
    private SysPlatformSettingTypeEnum settingType;
    @ApiModelProperty(value = "设置类型2")
    private String settingType2;
    @ApiModelProperty(value = "应用编码")
    private String appCode;
    @ApiModelProperty(value = "设置分组")
    private SysPlatformSettingGroupEnum settingGroup;
    @ApiModelProperty(value = "设置描述")
    private String settingDesc;
    //    @ApiModelProperty(value = "设置值")
//    private String settingVal;
    @ApiModelProperty(value = "默认值")
    private String defaultValue;
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;
}
