package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.menus.*;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepoProc;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Service
@Slf4j
@RequiredArgsConstructor
public class SysPlatformMenusServiceImpl implements SysPlatformMenusService {
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    private final SysPlatformMenusRepoProc sysPlatformMenusRepoProc;
    private final SysPlatformAppRepo sysPlatformAppRepo;

    @Override
    public ApiResult<Long> addMenusGroup(AddMenusParam param) {

        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS_GROUP.name());
        return saveDo(saveDo);
    }


    @Override
    public ApiResult<Long> addMenus(AddMenusParam param) {

        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS.name());
        return saveDo(saveDo);
    }

    @Override
    public ApiResult<Long> addButton(AddButtonParam param) {

        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.BUTTON.name());
        saveDo.setMenusType(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name());
        return saveDo(saveDo);
    }

    private ApiResult<Long> saveDo(SysPlatformMenusDO saveDo) {
        var list = sysPlatformMenusRepo.findAllByMenusCode(saveDo.getMenusCode());
        if (!list.isEmpty()) {
            var obj = list.get(0);
            return ApiResult.fail("菜单编码重复-（应用：" + obj.getMenusAppCode() + "-菜单名称：" + obj.getMenusName() + ")");
        }

        if (StringUtils.hasText(saveDo.getMenusParentCode())) {
            // 类型取上级菜单的类型，解决按钮时没有传递类型
            var parentMenu = sysPlatformMenusRepoProc.getByMenusCode(saveDo.getMenusParentCode());
            Assert.notNull(parentMenu, "上级菜单不存在");
            saveDo.setMenusType(parentMenu.getMenusType());
        }

        return ApiResult.ok(sysPlatformMenusRepo.save(saveDo).getId());
    }

    @Override
    public ApiResult<Boolean> updateMenusGroup(Long id, UpdateMenusParam updateMenusParam) {
        return updateMenus(id, updateMenusParam);
    }


    @Override
    public ApiResult<Boolean> updateMenus(Long id, UpdateMenusParam updateMenusParam) {
        //   AtomicReference<Boolean> allowUpdate = new AtomicReference<>(false);
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
//                    if (updateVerify(allowUpdate, sysPlatformAppDO, updateMenusParam.getMenusCode())) {
//                        return;
//                    }
//                    sysPlatformAppDO.setMenusAppCode(updateMenusParam.getMenusAppCode());
                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
                    sysPlatformAppDO.setMenusType(updateMenusParam.getMenusType());
//                    sysPlatformAppDO.setMenusCode(updateMenusParam.getMenusCode());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusRoute(updateMenusParam.getMenusRoute());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());

                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                    //     allowUpdate.set(true);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        //if (allowUpdate.get()) {
        return ApiResult.ok(true);
        //   } else {
        //     return ApiResult.fail("菜单编码已经存在,重复:");
        // }
    }

    @Override
    public ApiResult<Boolean> updateButton(Long id, UpdateButtonParam updateMenusParam) {

        AtomicReference<Boolean> allowUpdate = new AtomicReference<>(false);
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
//                    if (updateVerify(allowUpdate, sysPlatformAppDO, updateMenusParam.getMenusCode())) {
//                        return;
//                    }
                    //  sysPlatformAppDO.setMenusAppCode(updateMenusParam.getMenusAppCode());
                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
                    //   sysPlatformAppDO.setMenusCode(updateMenusParam.getMenusCode());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                    allowUpdate.set(true);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        if (allowUpdate.get()) {
            return ApiResult.ok(true);
        } else {
            return ApiResult.fail("菜单编码已经存在,重复:");
        }
    }

    private boolean updateVerify(AtomicReference<Boolean> allowUpdate,
                                 SysPlatformMenusDO sysPlatformAppDO, String menusCode) {
        //如果更新code 修改的code 不等于老code 需要进行唯一校验 如果是老code直接更新
        if (!sysPlatformAppDO.getMenusCode().equalsIgnoreCase(menusCode)) {
            var list =
                    sysPlatformMenusRepo.findAllByMenusCode(menusCode);
            if (!list.isEmpty()) {
                allowUpdate.set(false);
                return true;
                // throw new BusinessException("Code已经存在重复:" + updateMenusParam.getAppCode());
            }
        }
        return false;
    }

    @Override
    public ApiResult<Boolean> deleteFlagMenus(Long id) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO ->
                {
                    sysPlatformMenusDO.setDeleteFlag(1);
                    sysPlatformMenusRepo.save(sysPlatformMenusDO);
                }
                ,
                () -> {
                    throw new BusinessException("id不存在");
                });

        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<Boolean> updateMenusState(Long id, Boolean state) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO ->
                {
                    sysPlatformMenusDO.setMenusState(state);
                    sysPlatformMenusRepo.save(sysPlatformMenusDO);
                }
                ,
                () -> {
                    throw new BusinessException("id不存在");
                });

        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<SysPlatformMenusVO> getMenus(Long id) {
        var objDO = sysPlatformMenusRepo.findById(id);
        if (objDO.isPresent()) {
            return ApiResult.ok(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformVO(objDO.get()));
        } else {
            return ApiResult.fail("id不存在");
        }
    }

    @Override
    public ApiResult<List<SysPlatformMenusVO>> queryMenus(QueryMenusParam queryMenusParam) {
        List<SysPlatformMenusVO> listVO = sysPlatformMenusRepoProc.queryListMng(queryMenusParam)
                .stream()
                .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                .collect(Collectors.toList());
        return ApiResult.ok(listVO);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getMenusTypeEnum() {
//        List<SysUdcVO> sysUdcVOList = new ArrayList<>();
//        sysUdcVOList.add(PlatformConstantUtil.newSysUdcVO(PlatformEnum.PLATFORM_MENUS_TYPE_SYS));
//        sysUdcVOList.add(PlatformConstantUtil.newSysUdcVO(PlatformEnum.PLATFORM_MENUS_TYPE_BUS));
        return ApiResult.ok(
                List.of(
                        PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.getUdcVO(),
                        PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.getUdcVO()
                )

        );
    }

    @Override
    public ApiResult<GetAppMenusVO> getAllAppMenus() {
        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();

        getAppMenusVO.setSysPlatformAppVOS(
                sysPlatformAppRepo.findAll()
                        .stream()
                        .filter(sysPlatformAppDO -> sysPlatformAppDO.getAppState() && sysPlatformAppDO.getDeleteFlag() == 0)
                        .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                        .collect(Collectors.toList()));

        getAppMenusVO.setSysPlatformMenusVOS(
                sysPlatformMenusRepo.findAll()
                        .stream()
                        .filter(sysPlatformMenusDO -> sysPlatformMenusDO.getMenusState() && sysPlatformMenusDO.getDeleteFlag() == 0)
                        .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                        .collect(Collectors.toList())
        );
        return ApiResult.ok(getAppMenusVO);
    }

    @Override
    public ApiResult<GetAppMenusVO> getSysAppMenusAll(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        String menusType = null;
        if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name();
        } else if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name();
        }

        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(sysPlatformAppRepo.findByAppType(appType)
                    .stream()
                    .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                    .collect(Collectors.toList()));

        }
        if (menusType != null) {
            getAppMenusVO.setSysPlatformMenusVOS(
                    sysPlatformMenusRepo.findAllByMenusTypeAndDeleteFlag(
                                    menusType,
                                    0).stream()
                            .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                            .collect(Collectors.toList())
            );
        }
        return ApiResult.ok(getAppMenusVO);
    }

    @Override
    public ApiResult<Boolean> deleteMenus(Long id) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO -> {
            Integer count = sysPlatformMenusRepo.findAllByMenusParentCode(sysPlatformMenusDO.getMenusCode()).size();
            if (count != 0) {
                throw new BusinessException("请先删除子菜单。子菜单数量：" + count);
            } else {
                sysPlatformMenusRepo.deleteById(id);
            }

        }, () -> {
            throw new BusinessException("id不存在");
        });

        return ApiResult.ok();
    }

    @Override
    public ApiResult<GetAppMenusVO> getSysBusAppMenus(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        String menusType = null;
        if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name();
        } else if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name();
        }

        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(sysPlatformAppRepo.findByAppTypeAndAppState(appType, true)
                    .stream()
                    .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                    .collect(Collectors.toList()));

        }
        if (menusType != null) {
            getAppMenusVO.setSysPlatformMenusVOS(
                    sysPlatformMenusRepo.findAllByMenusTypeAndMenusStateAndDeleteFlag(
                                    menusType,
                                    // PlatformMenusNodeEnum.MENUS.name(),
                                    true,
                                    0).stream()
                            .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                            .collect(Collectors.toList())
            );
        }
        return ApiResult.ok(getAppMenusVO);
    }


}
