package com.elitescloud.cloudt.platform.service.repo;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.menus.QueryMenusParam;
import com.querydsl.core.types.ExpressionUtils;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/17
 */
@Repository
public class SysPlatformMenusRepoProc extends BaseRepoProc<SysPlatformMenusDO> {
    private static final QSysPlatformMenusDO QDO = QSysPlatformMenusDO.sysPlatformMenusDO;

    public SysPlatformMenusRepoProc() {
        super(QDO);
    }

    public String getAppCode(String code) {
        return jpaQueryFactory.select(QDO.menusAppCode)
                .from(QDO)
                .where(QDO.menusCode.eq(code))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取菜单列表管理
     *
     * @param queryMenusParam 查询参数
     * @return 菜单列表
     */
    public List<SysPlatformMenusDO> queryListMng(QueryMenusParam queryMenusParam) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.menusAppCode, queryMenusParam.getAppCode())
                .andLike(QDO.menusName, queryMenusParam.getMenusName())
                .andLike(QDO.menusCode, queryMenusParam.getMenusCode())
                .and(queryMenusParam.getMenusType() != null, () -> QDO.menusType.eq(queryMenusParam.getMenusType().name()))
                .andEq(QDO.menusState, queryMenusParam.getMenusState())
                .andEq(QDO.nodeType, queryMenusParam.getNodeType())
                .build();
        return super.getList(predicate)
                .stream()
                .sorted(Comparator.comparing(SysPlatformMenusDO::getMenusOrder, Comparator.nullsFirst(Integer::compareTo).reversed()))
                .collect(Collectors.toList());
    }

    /**
     * 根据菜单编码获取菜单信息
     *
     * @param menusCode 菜单编码
     * @return 菜单信息
     */
    public SysPlatformMenusDO getByMenusCode(@NotBlank String menusCode) {
        return super.getOneByValue(QDO.menusCode, menusCode);
    }
}
