package com.elitescloud.cloudt.platform.service.repo;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformNumberRuleDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformNumberRuleDO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleQParam;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * 2020-10-11
 */
@Repository
public class SysPlatformNumberRuleRepoProc extends BaseRepoProc<SysPlatformNumberRuleDO> {

    private static final QSysPlatformNumberRuleDO QDO = QSysPlatformNumberRuleDO.sysPlatformNumberRuleDO;

    public SysPlatformNumberRuleRepoProc() {
        super(QDO);
    }

    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    public boolean existsRuleCode(String ruleCode) {
        return exists(QDO.ruleCode, ruleCode);
    }

    public boolean existsRuleCode(String ruleCode, Long id) {
        return exists(QDO.ruleCode, ruleCode, id);
    }

    public Boolean getEnabled(long id) {
        return super.getValue(QDO.enabled, id);
    }

    public PagingVO<SysPlatformNumberRuleDO> queryForPage(SysPlatformNumberRuleQParam param) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.hasText(param.getAppCode()), QDO.appCode, param.getAppCode())
                .andLike(StringUtils.hasText(param.getRuleCode()), QDO.ruleCode, param.getRuleCode())
                .andLike(StringUtils.hasText(param.getRuleName()), QDO.ruleName, param.getRuleName())
                .build();

        JPAQuery<SysPlatformNumberRuleDO> jpaQuery = jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(predicate);
        return queryByPage(jpaQuery, param.getPageRequest());
    }

    /**
     * 根据编号获取ID
     *
     * @param ruleCode
     * @return
     */
    public Long getIdByCode(String ruleCode) {
        return getIdByValue(QDO.ruleCode, ruleCode);
    }

    public List<String> getCodes(Collection<Long> ids) {
        return getValue(QDO.ruleCode, ids);
    }

    public List<Long> getIdsByCode(Collection<String> codes) {
        return getIdsByValue(QDO.ruleCode, codes);
    }

    public List<String> filterCode(Collection<String> codes) {
        return jpaQueryFactory.select(QDO.ruleCode)
                .from(QDO)
                .where(QDO.ruleCode.in(codes))
                .fetch();
    }
}
