package com.elitescloud.cloudt.platform.service.repo;


import com.elitescloud.cloudt.platform.model.entity.SysPlatformSettingDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;


/**
 * @Description: 平台应用udc
 * @author: niu.chen
 * @date: 2022.09.15
 **/

@Repository
public interface SysPlatformSettingRepo extends JpaRepository<SysPlatformSettingDO, Long>,
        QuerydslPredicateExecutor<SysPlatformSettingDO> {

    Optional<SysPlatformSettingDO> findBySettingNo(String settingNo);

    Optional<SysPlatformSettingDO> findByIdNotAndSettingNo(Long id, String settingNo);

    void deleteAllByIdIn(List<Long> ids);

    void deleteAllBySettingNoIn(List<String> nos);

}

