package com.elitescloud.cloudt.platform.service.repo;


import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcDO;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;


/**
 * @Description: 平台应用udc
 * @author: niu.chen
 * @date: 2022.09.15
 **/

@Repository
public class SysPlatformUdcRepoProc extends BaseRepoProc<SysPlatformUdcDO> {
    private static final QSysPlatformUdcDO QDO = QSysPlatformUdcDO.sysPlatformUdcDO;

    public SysPlatformUdcRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码和udc编码删除
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     */
    @Transactional(rollbackFor = Exception.class)
    public void deleteByAppCodeAndUdcCode(@NotBlank String appCode, @NotBlank String udcCode) {
        super.jpaQueryFactory.delete(QDO)
                .where(QDO.udcCode.eq(udcCode).and(QDO.appCode.eq(appCode)))
                .execute();
    }
}

