package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.cloudt.common.base.param.CodeNameParam;
import com.elitescloud.cloudt.core.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformUdcValueDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcValueDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Repository
public class SysPlatformUdcValueRepoProc extends BaseRepoProc<SysPlatformUdcValueDO> {
    private static final QSysPlatformUdcValueDO QDO = QSysPlatformUdcValueDO.sysPlatformUdcValueDO;

    public SysPlatformUdcValueRepoProc() {
        super(QDO);
    }

    @Transactional(rollbackFor = Exception.class)
    public void delete(@NotBlank String appCode, @NotBlank String udcCode, @NotBlank String udcValue, Boolean allowDefault) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.udcCode, udcValue)
                .andEq(QDO.appCode, appCode)
                .andEq(QDO.udcValueCode, udcValue)
                .andEq(QDO.allowDefault, allowDefault)
                .build();
    }

    /**
     * 查询值列表
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @param enabled 启用状态
     * @return 值列表
     */
    public List<SysPlatformUdcValueDO> queryValue(@NotBlank String appCode, @NotBlank String udcCode, Boolean enabled) {
        var predicate = PredicateBuilder.builder()
                .andEq(true, QDO.udcCode, udcCode)
                .andEq(true, QDO.appCode, appCode)
                .andEq(enabled != null, QDO.allowStart, enabled)
                .build();
        return super.getList(predicate);
    }

    /**
     * 获取值列表
     *
     * @param appCode
     * @param udcCode
     * @return
     */
    public List<CodeNameParam> getValueList(@NotBlank String appCode, @NotBlank String udcCode, Boolean enabled) {
        var predicate = PredicateBuilder.builder()
                .andEq(true, QDO.udcCode, udcCode)
                .andEq(true, QDO.appCode, appCode)
                .andEq(enabled != null, QDO.allowStart, enabled)
                .build();
        return jpaQueryFactory.select(Projections.bean(CodeNameParam.class, QDO.udcValueCode.as("code"), QDO.udcValueName.as("name")))
                .from(QDO)
                .where(predicate)
                .orderBy(QDO.udcOrder.asc())
                .fetch();
    }
}

