package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.api.AddApiParam;
import com.elitescloud.cloudt.platform.model.vo.sbean.SysApiManageQueryBean;
import com.elitescloud.cloudt.platform.service.SysPlatformApiManageService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;
import java.util.Map;

/**
 * @deprecated 已弃用，改用业务对象操作
 */
@RestController
@Api(tags = {"【已弃用】接口管理"})
@ApiIgnore
@RequestMapping("/sys/platform/apiManage")
@BusinessObject(businessType = BusinessObjectConstant.SYS_PLATFORM_MENUS, businessDoClass = SysPlatformMenusDO.class)
@Deprecated(since = "3.3.0")
public class SysPlatformApiManageController {

    private final SysPlatformApiManageService sysPlatformApiManageService;

    public SysPlatformApiManageController(SysPlatformApiManageService sysPlatformApiManageService, BeanSearcherFactory beanSearcherFactory) {
        this.sysPlatformApiManageService = sysPlatformApiManageService;
    }

    /**
     * 添加接口
     *
     * @param addApiParam 添加接口参数
     * @return 保存结果
     */
    @PostMapping("/add")
    @ApiOperation(value = "接口管理-添加接口", notes = "接口管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.ADD,operationDescription = "添加接口"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> addApi(@RequestBody @Validated AddApiParam addApiParam) {
        return sysPlatformApiManageService.addApi(addApiParam);
    }

    /**
     * 修改接口
     *
     * @param id             id
     * @param updateApiParam 修改接口参数
     * @return 修改结果
     */
    @PostMapping("/update/{id}")
    @ApiOperation(value = "接口管理-修改接口", notes = "接口管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "修改接口"
    )
    public ApiResult<Boolean> updateApi(@PathVariable Long id, @RequestBody AddApiParam updateApiParam) {
        return sysPlatformApiManageService.updateApi(id, updateApiParam);
    }


    /**
     * @param params 查询参数map
     * @return 查询结果
     */
    @PostMapping(value = "/query")
    @ApiOperation(value = "接口管理-查询接口", notes = "接口管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT_PAGE,operationDescription = "查询接口"
    )
    public ApiResult<PagingVO<SysApiManageQueryBean>> query(
            @RequestBody Map<String, Object> params) {
        return sysPlatformApiManageService.query(params);
    }

    /**
     * 删除接口
     *
     * @param id id
     * @return 删除结果
     */
    @PutMapping("/delete/{id}")
    @ApiOperation(value = "接口管理-删除接口", notes = "接口管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.DELETE,operationDescription = "删除接口"
    )
    public ApiResult<Boolean> deleteApi(@PathVariable Long id) {
        return sysPlatformApiManageService.deleteApi(id);
    }

    @GetMapping("/enum/getApiRequestTypeEnum")
    @ApiOperation(value = "接口请求类型枚举", notes = "接口管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "接口请求类型枚举"
    )
    public ApiResult<List<SysUdcVO>> getApiRequestTypeEnum() {
        return sysPlatformApiManageService.getApiRequestTypeEnum();
    }

    @GetMapping("/enum/getApiFieldTypeEnum")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "接口字段类型枚举"
    )
    @ApiOperation(value = "接口字段类型枚举", notes = "接口管理")
    public ApiResult<List<SysUdcVO>> getApiFieldTypeEnum() {
        return sysPlatformApiManageService.getApiFieldTypeEnum();
    }
}
