package com.elitescloud.cloudt.platform.model.constant;


import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 菜单节点类型
 * **/
public enum PlatformAppMenusTypeEnum {
    MENUS_TYPE_SYS("SYS_PLATFORM", "MENUS_TYPE", "菜单类型", "系统",1),
    MENUS_TYPE_BUS("SYS_PLATFORM", "MENUS_TYPE", "菜单类型", "业务",2),


    ;


    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformAppMenusTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }


    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public String getDescription() {
        return description;
    }

    private static final Map<String, PlatformAppMenusTypeEnum> ALL = Arrays.stream(PlatformAppMenusTypeEnum.values())
            .collect(Collectors.toMap(PlatformAppMenusTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析类型
     *
     * @param value 待解析字符串
     * @return
     */
    public static PlatformAppMenusTypeEnum parse(String value) {
        if (CharSequenceUtil.isBlank(value)) {
            return null;
        }
        return ALL.get(value);
    }
}
