package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 菜单与业务对象操作的关联.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
@Entity
@Table(name = "sys_menu_operation", indexes = {
        @Index(name = "idx_menu_operation_app", columnList = "appCode"),
        @Index(name = "idx_menu_operation_menu", columnList = "menusCode"),
        @Index(name = "idx_menu_operation_opera", columnList = "operationCode"),
})
@Comment("菜单与业务对象操作的关联")
@DynamicInsert
@Getter
@Setter
public class SysMenuOperationDO extends BaseModel {
    private static final long serialVersionUID = -5942604742706438755L;

    @Comment("应用编码")
    @Column(nullable = false)
    private String appCode;

    @Comment("菜单编码")
    @Column(nullable = false)
    private String menusCode;

    @Comment("业务操作编码")
    @Column()
    private String operationCode;
}
