package com.elitescloud.cloudt.platform.model.entity;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/9 10:53
 */

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 数据源表;
 * @author : http://www.chiner.pro
 * @date : 2023-10-9
 */
@Entity
@ApiModel(value = "数据源表",description = "")
@Table(name="sys_database_source")
@org.hibernate.annotations.Table(appliesTo = "sys_database_source", comment = "数据源表")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysPlatformDatabaseSourceDO extends BaseModel implements Serializable{

    /** 数据源名称 */
    @ApiModelProperty(name = "数据源名称",notes = "")
    @Comment("数据源名称")
    @Column(nullable = false)
    private String dbsName ;

    @ApiModelProperty(name = "驱动类",notes = "")
    @Comment("驱动类")
    @Column(nullable = false)
    private String dbsDriverClass ;

    @ApiModelProperty(name = "连接地址",notes = "")
    @Comment("连接地址")
    @Column(nullable = false)
    private String dbsUrl ;

    @ApiModelProperty(name = "数据库名称",notes = "")
    @Comment("数据库名称")
    @Column(nullable = false)
    private String dbsUsername ;

    @ApiModelProperty(name = "数据库密码",notes = "")
    @Comment("数据库密码")
    @Column(nullable = false)
    private String dbsPassword ;


    @ApiModelProperty(name = "数据库名称",notes = "")
    @Comment("数据库名称")
    @Column(nullable = false)
    private String dbsDbName ;

    @ApiModelProperty(name = "数据库端口",notes = "")
    @Comment("数据库端口")
    @Column(nullable = false)
    private String dbsDbPort ;

}
