package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <pre>
 *     系统配置表
 * </pre>
 *
 * @author Michael Li
 * 2020-06-15
 */
@Deprecated(forRemoval = true)
@Entity
@Table(name = "sys_platform_setting")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_setting", comment = "参数配置表")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@Accessors(chain = true)
@ApiModel(value = "参数配置表", description = "参数配置表")
@DynamicUpdate
public class SysPlatformSettingDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -7840804475330315230L;

    @ApiModelProperty(value = "设置的编号")
    @Comment("设置的编号")
    @Column(nullable = false, unique = true)
    private String settingNo;

    @ApiModelProperty(value = "设置名称")
    @Comment("设置名称")
    @Column()
    private String settingName;


    @ApiModelProperty(value = "设置类型 系统,业务")
    @Comment("设置类型系统,业务")
    @Column()
    private String settingType;

    @ApiModelProperty(value = "设置类型2")
    @Comment("设置类型2")
    @Column()
    private String settingType2;

    @ApiModelProperty(value = "应用编码")
    @Comment("应用编码")
    @Column()
    private String appCode;

    @ApiModelProperty(value = "设置分组")
    @Comment("设置分组")
    @Column()
    private String settingGroup;


    @ApiModelProperty(value = "设置描述")
    @Comment("设置描述")
    @Column
    private String settingDesc;

    @ApiModelProperty(value = "设置值")
    @Comment("设置值")
    @Column
    private String settingVal;

    @ApiModelProperty(value = "默认值")
    @Comment("默认值")
    @Column(name = "def_val")
    private String defaultValue;

    @ApiModelProperty(value = "排序号")
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformSettingDO that = (SysPlatformSettingDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
