package com.elitescloud.cloudt.platform.model.params.seq;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.29
 **/
@Data
public class SysPlatformSeqNumSaveParam {

    @ApiModelProperty(value = "应用编码")
    @NotBlank
    private String appCode;

    @ApiModelProperty(value = "下一编号代码")
    @NotBlank
    String code;

    @ApiModelProperty(value = "下一编号名称")
    @NotBlank
    String name;

    @ApiModelProperty(value = "下一编号分类")
    String numberClass;

    @ApiModelProperty(value = "下一编号步长")
    @NotNull
    Integer step;

    @ApiModelProperty(value = "下一编号取值")
    @NotNull
    Long nextNumber;

    @ApiModelProperty(value = "下一编号周期[UDC]SYS:NNPERIOD")
    String nnPeriod;

    @ApiModelProperty(value = "是否启用")
    Boolean enabled;

    /**
     * 是否系统内置
     */
    @ApiModelProperty(value = "是否系统内置", position = 6)
    private Boolean internal;
//    @ApiModelProperty(value = "发号时间")
//    LocalDateTime nnTime;
//
//    @ApiModelProperty("乐观锁标记")
//    Integer version;
}
