package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "sys_platform_app", description = "平台应用管理")
public class SysPlatformAppVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -2305497711668367767L;

    @ApiModelProperty("应用编码")
    private String appCode;

    @ApiModelProperty("应用名称")
    private String appName;

    @ApiModelProperty("应用类型")
    private String appType;

    @ApiModelProperty(value = "应用图标")
    private String icon;

    @ApiModelProperty("描述")
    private String appDescribe;

    @ApiModelProperty("状态")
    private Boolean appState;

    @ApiModelProperty("排序")
    private Integer appOrder;

    @ApiModelProperty(value = "是否外部应用", position = 7)
    private Boolean outerApp;

    @ApiModelProperty(value = "授权类型", position = 8)
    private String authType;

    @ApiModelProperty(value = "访问URL", position = 9)
    private String url;

    @ApiModelProperty(value = "生成token的URL", position = 10)
    private String tokenUrl;
}
