package com.elitescloud.cloudt.platform.model.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 菜单挂载的操作信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
@Getter
@Setter
@ApiModel(description = "菜单挂载的操作信息")
public class MenuOperationRespVO implements Serializable {
    private static final long serialVersionUID = -3649620240210453131L;

    @ApiModelProperty(value = "记录唯一ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "应用编码", position = 2)
    private String appCode;

    @ApiModelProperty(value = "应用名称", position = 2)
    private String appName;

    @ApiModelProperty(value = "菜单编码", position = 3)
    private String menusCode;

    @ApiModelProperty(value = "菜单名称", position = 3)
    private String menuName;

    @ApiModelProperty(value = "业务对象编码", position = 4)
    private String businessObjectCode;

    @ApiModelProperty(value = "业务对象名称", position = 4)
    private String businessObjectName;

    @ApiModelProperty(value = "操作编码", position = 6)
    private String operationCode;

    @ApiModelProperty(value = "操作名称", position = 7)
    private String operationName;

    @ApiModelProperty(value = "接口请求类型", position = 8)
    private String apiMethod;

    @ApiModelProperty(value = "接口请求路径", position = 9)
    private String apiUrl;
}
