package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2023/1/17
 */
public interface SysPlatformAreaService {

    /**
     * 行政区域树
     *
     * @param tree 是否返回树状，默认false
     * @return 行政区域树
     */
    ApiResult<List<AreaMngTreeRespVO>> tree(Boolean tree);

    /**
     * 保存行政区域
     *
     * @param saveVO 行政区域信息
     * @return 区域ID
     */
    ApiResult<Long> save(PlatformAreaSaveVO saveVO);

    /**
     * 获取行政区域详情
     *
     * @param id 区域ID
     * @return 区域详情
     */
    ApiResult<AreaDetailRespVO> get(@NotNull Long id);

    /**
     * 删除行政区域详情
     *
     * @param id 区域ID
     * @return 区域ID
     */
    ApiResult<Long> delete(@NotNull Long id);

    /**
     * 重构组织树
     *
     * @return 结果
     */
    ApiResult<Boolean> execReBuildTree();
}
