/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.UdcConvert;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcValueDO;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcValueParam;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.UdcValueSaveVO;
import com.elitescloud.cloudt.platform.model.params.udc.UpdateUdcParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueMngVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueVO;
import com.elitescloud.cloudt.platform.service.SysPlatformUdcService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcValueRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcValueRepoProc;
import com.elitescloud.cloudt.system.service.SysTenantBasicDataService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectEnum;
import com.elitescloud.cloudt.system.service.config.TenantProperties;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class SysPlatformUdcServiceImpl
extends BaseServiceImpl
implements SysPlatformUdcService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformUdcServiceImpl.class);
    private final SysPlatformUdcRepo sysPlatformUdcRepo;
    private final SysPlatformUdcValueRepoProc sysPlatformUdcValueRepoProc;
    private final SysPlatformUdcValueRepo sysPlatformUdcValueRepo;
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final UdcProvider udcProvider;
    private final SysTenantBasicDataService tenantBasicDataService;
    @Autowired(required=false)
    private TenantProperties tenantProperties;
    private final OperationLogMqMessageService operationLogMqMessageService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addUdc(AddUdcParam addUdcParam) {
        List<SysPlatformAppDO> appList = this.sysPlatformAppRepo.findByAppCode(addUdcParam.getAppCode());
        if (appList.size() != 1) {
            return ApiResult.fail((String)(appList.isEmpty() ? "\u5e94\u7528\u7f16\u7801\u4e0d\u5b58\u5728" : "\u5e94\u7528\u7f16\u7801\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u4e2a"));
        }
        int count = this.sysPlatformUdcRepo.countAllByAppCodeAndUdcCode(addUdcParam.getAppCode(), addUdcParam.getUdcCode());
        if (count != 0) {
            return ApiResult.fail((String)"\u5e94\u7528UDC\u7f16\u7801\u91cd\u590d");
        }
        SysPlatformUdcDO udcDo = UdcConvert.INSTANCE.saveParamToDo(addUdcParam);
        this.sysPlatformUdcRepo.saveAndFlush((Object)udcDo);
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, addUdcParam.getUdcCode(), OperationTypeEnum.ADD, "\u65b0\u589eUDC");
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        return ApiResult.ok((Object)udcDo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addUdcValue(AddUdcValueParam addUdcValueParam) {
        SysPlatformUdcDO udcDo = this.sysPlatformUdcRepo.findAllByAppCodeAndUdcCode(addUdcValueParam.getAppCode(), addUdcValueParam.getUdcCode());
        if (udcDo == null) {
            return ApiResult.fail((String)("\u5e94\u7528APP\u7684UDC\u7f16\u7801\u4e0d\u5b58\u5728," + addUdcValueParam.getAppCode() + "," + addUdcValueParam.getUdcCode()));
        }
        List<SysPlatformUdcValueDO> valueList = this.sysPlatformUdcValueRepoProc.queryValue(udcDo.getAppCode(), udcDo.getUdcCode(), null);
        if (!valueList.isEmpty()) {
            HashSet<String> codes = new HashSet<String>();
            HashSet<String> names = new HashSet<String>();
            for (SysPlatformUdcValueDO valueDO : valueList) {
                if (codes.contains(addUdcValueParam.getUdcValueCode())) {
                    return ApiResult.fail((String)"\u503c\u7f16\u7801\u5df2\u5b58\u5728");
                }
                codes.add(valueDO.getUdcValueCode());
                if (names.contains(addUdcValueParam.getUdcValueName())) {
                    return ApiResult.fail((String)"\u503c\u540d\u79f0\u5df2\u5b58\u5728");
                }
                names.add(valueDO.getUdcValueName());
            }
        }
        SysPlatformUdcValueDO udcValueDo = UdcConvert.INSTANCE.saveParamToDo(addUdcValueParam);
        udcValueDo.setAllowDefault(true);
        udcValueDo = (SysPlatformUdcValueDO)((Object)this.sysPlatformUdcValueRepo.save((Object)udcValueDo));
        this.clearCache(addUdcValueParam.getAppCode(), udcValueDo.getUdcCode());
        this.syncTenantUdc(udcDo.getAppCode(), udcDo.getUdcCode());
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, udcValueDo.getUdcCode(), OperationTypeEnum.ADD, "\u65b0\u589eUDC\u503c" + udcValueDo.getUdcValueCode() + ":" + udcValueDo.getUdcValueName());
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        return ApiResult.ok((Object)udcValueDo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateUdcValue(UdcValueSaveVO saveVO) {
        Assert.notNull((Object)saveVO.getId(), (String)"ID\u4e3a\u7a7a");
        SysPlatformUdcValueDO udcValueDO = (SysPlatformUdcValueDO)((Object)this.sysPlatformUdcValueRepoProc.get(saveVO.getId()));
        Assert.notNull((Object)((Object)udcValueDO), (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        List<SysPlatformUdcValueDO> valueList = this.sysPlatformUdcValueRepoProc.queryValue(udcValueDO.getAppCode(), udcValueDO.getUdcCode(), null);
        if (!valueList.isEmpty()) {
            HashSet<String> codes = new HashSet<String>();
            HashSet<String> names = new HashSet<String>();
            for (SysPlatformUdcValueDO valueDO : valueList) {
                if (valueDO.getId().equals(saveVO.getId())) continue;
                if (codes.contains(saveVO.getUdcValueCode())) {
                    return ApiResult.fail((String)"\u503c\u7f16\u7801\u5df2\u5b58\u5728");
                }
                codes.add(valueDO.getUdcValueCode());
                if (names.contains(saveVO.getUdcValueName())) {
                    return ApiResult.fail((String)"\u503c\u540d\u79f0\u5df2\u5b58\u5728");
                }
                names.add(valueDO.getUdcValueName());
            }
        }
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, udcValueDO.getUdcCode(), OperationTypeEnum.UPDATE, "\u4fee\u6539UDC\u503c:" + udcValueDO.getUdcValueCode());
        dto.setOperationBeforeData(JSONUtil.toJsonString((Object)((Object)udcValueDO)));
        saveVO.setUdcOrder((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getUdcOrder(), (Object)0));
        saveVO.setAllowStart((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getAllowStart(), (Object)true));
        UdcConvert.INSTANCE.copySaveVo2Do(saveVO, udcValueDO);
        this.sysPlatformUdcValueRepo.save((Object)udcValueDO);
        dto.setOperationAfterData(JSONUtil.toJsonString((Object)((Object)udcValueDO)));
        this.syncTenantUdc(udcValueDO.getAppCode(), udcValueDO.getUdcCode());
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteFlagUdc(Long id) {
        this.sysPlatformUdcRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            sysPlatformUdcDO.setDeleteFlag(1);
            this.sysPlatformUdcRepo.save(sysPlatformUdcDO);
            this.sysPlatformUdcValueRepo.findAllByAppCodeAndUdcCode(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode()).forEach(sysPlatformUdcValueDO -> {
                sysPlatformUdcValueDO.setDeleteFlag(1);
                this.sysPlatformUdcValueRepo.save(sysPlatformUdcValueDO);
            });
            this.clearCache(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
            this.syncTenantUdc(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteFlagUdcValue(Long id) {
        this.sysPlatformUdcValueRepo.findById(id).ifPresentOrElse(sysPlatformUdcValueDO -> {
            sysPlatformUdcValueDO.setDeleteFlag(1);
            this.sysPlatformUdcValueRepo.save(sysPlatformUdcValueDO);
            OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, sysPlatformUdcValueDO.getUdcCode(), OperationTypeEnum.DELETE, "\u5220\u9664UDC\u503c" + sysPlatformUdcValueDO.getUdcValueCode() + ":" + sysPlatformUdcValueDO.getUdcValueName());
            this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
            this.clearCache(sysPlatformUdcValueDO.getAppCode(), sysPlatformUdcValueDO.getUdcCode());
            this.syncTenantUdc(sysPlatformUdcValueDO.getAppCode(), sysPlatformUdcValueDO.getUdcCode());
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteUdc(Long id) {
        Optional udcDoOp = this.sysPlatformUdcRepo.findById(id);
        if (udcDoOp.isPresent()) {
            SysPlatformUdcDO udcDo = (SysPlatformUdcDO)((Object)udcDoOp.get());
            List<SysPlatformUdcValueDO> list = this.sysPlatformUdcValueRepo.findAllByAppCodeAndUdcCode(udcDo.getAppCode(), udcDo.getUdcCode());
            if (list.size() > 0) {
                return ApiResult.fail((String)"\u8bf7\u5148\u5220\u9664\u5168\u90e8UDC\u5b50\u9879");
            }
            this.sysPlatformUdcRepo.deleteById(id);
            OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, udcDo.getUdcCode(), OperationTypeEnum.DELETE, "\u5220\u9664UDC" + udcDo.getUdcCode() + ":" + udcDo.getUdcName());
            this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
            this.clearCache(udcDo.getAppCode(), udcDo.getUdcCode());
            this.syncTenantUdc(udcDo.getAppCode(), udcDo.getUdcCode());
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteUdcValue(Long id) {
        SysPlatformUdcValueDO valueDO = (SysPlatformUdcValueDO)((Object)this.sysPlatformUdcValueRepoProc.get(id));
        if (valueDO == null) {
            return ApiResult.noData();
        }
        this.sysPlatformUdcValueRepo.deleteById(id);
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, valueDO.getUdcCode(), OperationTypeEnum.DELETE, "\u5220\u9664UDC\u503c" + valueDO.getUdcValueCode() + ":" + valueDO.getUdcValueName());
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        this.clearCache(valueDO.getAppCode(), valueDO.getUdcCode());
        this.syncTenantUdc(valueDO.getAppCode(), valueDO.getUdcCode());
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateUdc(Long id, UpdateUdcParam updateUdcParam) {
        this.sysPlatformUdcRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, sysPlatformUdcDO.getUdcCode(), OperationTypeEnum.UPDATE, "\u4fee\u6539UDC");
            dto.setOperationBeforeData(JSONUtil.toJsonString((Object)sysPlatformUdcDO));
            sysPlatformUdcDO.setUdcName(updateUdcParam.getUdcName());
            sysPlatformUdcDO.setAllowUpdate(updateUdcParam.getAllowUpdate());
            sysPlatformUdcDO.setAllowAddValue(updateUdcParam.getAllowAddValue());
            sysPlatformUdcDO.setUdcDescribe(updateUdcParam.getUdcDescribe());
            sysPlatformUdcDO.setParentUdcCode(updateUdcParam.getParentUdcCode());
            this.sysPlatformUdcRepo.save(sysPlatformUdcDO);
            dto.setOperationAfterData(JSONUtil.toJsonString((Object)sysPlatformUdcDO));
            this.clearCache(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
            this.syncTenantUdc(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
            this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateUdcValueAllowStart(Long id, Boolean allowStart) {
        this.sysPlatformUdcValueRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            sysPlatformUdcDO.setAllowStart(allowStart);
            this.sysPlatformUdcValueRepo.save(sysPlatformUdcDO);
            this.clearCache(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
            this.syncTenantUdc(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
            OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO((Enum)BusinessObjectEnum.SysPlatformUdc, sysPlatformUdcDO.getUdcCode(), OperationTypeEnum.UPDATE, "\u66f4\u65b0UDC\u72b6\u6001\uff1a" + allowStart);
            this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<SysPlatformUdcVO> getUdc(Long id) {
        AtomicReference atomicUdcVO = new AtomicReference();
        this.sysPlatformUdcRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            SysPlatformUdcVO sysPlatformUdcVO1 = UdcConvert.INSTANCE.selectDOToVO((SysPlatformUdcDO)((Object)sysPlatformUdcDO));
            List<SysPlatformUdcValueVO> udcValueVOList = this.sysPlatformUdcValueRepo.findAllByAppCodeAndUdcCode(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode()).stream().map(UdcConvert.INSTANCE::selectDOToVO).sorted(this.comparatorOfUdcValue()).collect(Collectors.toList());
            sysPlatformUdcVO1.setSysPlatformUdcValueVOList(udcValueVOList);
            atomicUdcVO.set(sysPlatformUdcVO1);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)((SysPlatformUdcVO)atomicUdcVO.get()));
    }

    @Override
    public ApiResult<PagingVO<SysPlatformUdcVO>> queryUdc(QueryUdcParam param) {
        QSysPlatformUdcDO qdo = QSysPlatformUdcDO.sysPlatformUdcDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)qdo.appCode).eq(arg_0), (Object)param.getAppCode()).and(arg_0 -> ((StringPath)qdo.udcName).like(arg_0), StringUtils.hasText((String)param.getUdcName()) ? "%" + param.getUdcName() + "%" : null).and(arg_0 -> ((StringPath)qdo.udcCode).like(arg_0), StringUtils.hasText((String)param.getUdcCode()) ? "%" + param.getUdcCode() + "%" : null).getPredicate();
        PageRequest pageRequest = param.getPageRequest();
        if (pageRequest.getSort().isEmpty()) {
            pageRequest = pageRequest.withSort(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        }
        Page page = this.sysPlatformUdcRepo.findAll(predicate, (Pageable)pageRequest);
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.get().map(UdcConvert.INSTANCE::selectDOToVO).collect(Collectors.toList()));
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<List<CodeNameParam>> getValueList(String appCode, String udcCode) {
        Assert.hasText((String)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)udcCode, (String)"UDC\u7f16\u7801\u4e3a\u7a7a");
        List<CodeNameParam> result = this.sysPlatformUdcValueRepoProc.getValueList(appCode, udcCode, true);
        return ApiResult.ok(result);
    }

    @Override
    public List<SysPlatformUdcValueMngVO> queryUdcValue(HashMap<String, Object> param) {
        Assert.notNull((Object)param.get("appCode").toString(), (String)"\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)param.get("udcCode").toString(), (String)"udc\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<SysPlatformUdcValueMngVO> udcValueMngVOList = this.sysPlatformUdcValueRepoProc.queryUdcValueList(param);
        if (CollectionUtils.isEmpty(udcValueMngVOList)) {
            return null;
        }
        return udcValueMngVOList;
    }

    private void syncTenantUdc(String appCode, String udcCode) {
        if (this.tenantProperties == null || Boolean.FALSE.equals(this.tenantProperties.isAutoSyncBasicData())) {
            return;
        }
        this.taskExecutor.execute(() -> {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.tenantBasicDataService.syncUdc(appCode, udcCode);
        });
    }

    private void clearCache(String appCode, String udcCode) {
        this.udcProvider.clearCache(appCode, udcCode);
    }

    private Comparator<SysPlatformUdcValueVO> comparatorOfUdcValue() {
        return Comparator.comparing(SysPlatformUdcValueVO::getUdcOrder, Comparator.nullsFirst(Integer::compareTo)).reversed();
    }

    public SysPlatformUdcServiceImpl(SysPlatformUdcRepo sysPlatformUdcRepo, SysPlatformUdcValueRepoProc sysPlatformUdcValueRepoProc, SysPlatformUdcValueRepo sysPlatformUdcValueRepo, SysPlatformAppRepo sysPlatformAppRepo, UdcProvider udcProvider, SysTenantBasicDataService tenantBasicDataService, OperationLogMqMessageService operationLogMqMessageService) {
        this.sysPlatformUdcRepo = sysPlatformUdcRepo;
        this.sysPlatformUdcValueRepoProc = sysPlatformUdcValueRepoProc;
        this.sysPlatformUdcValueRepo = sysPlatformUdcValueRepo;
        this.sysPlatformAppRepo = sysPlatformAppRepo;
        this.udcProvider = udcProvider;
        this.tenantBasicDataService = tenantBasicDataService;
        this.operationLogMqMessageService = operationLogMqMessageService;
    }
}

