/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysMenuOperationDO;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.menus.QueryMenusParam;
import com.elitescloud.cloudt.platform.model.vo.MenusAndOperationNumVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;

@Repository
public class SysPlatformMenusRepoProc
extends BaseRepoProc<SysPlatformMenusDO> {
    private static final QSysPlatformMenusDO QDO = QSysPlatformMenusDO.sysPlatformMenusDO;
    private static final QSysPlatformMenusApiDO QDO_API = QSysPlatformMenusApiDO.sysPlatformMenusApiDO;
    private static final QSysMenuOperationDO QDO_MENU_OPERATION = QSysMenuOperationDO.sysMenuOperationDO;
    private static final QSysBusinessOperationDO QDO_OPERATION = QSysBusinessOperationDO.sysBusinessOperationDO;

    public SysPlatformMenusRepoProc() {
        super((EntityPathBase)QDO);
    }

    public String getAppCode(String menusCode) {
        return (String)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysPlatformMenusRepoProc.QDO.menusAppCode).from((EntityPath)QDO)).where((Predicate)SysPlatformMenusRepoProc.QDO.menusCode.eq((Object)menusCode))).limit(1L)).fetchOne();
    }

    public List<MenusAndOperationNumVO> getMenusSumApi(String appCode) {
        Expression apiNumExpr = (Expression)JPAExpressions.select((Expression)SysPlatformMenusRepoProc.QDO_API.id.count().as("apiNum")).from(new EntityPath[]{QDO_API}).where(new Predicate[]{SysPlatformMenusRepoProc.QDO_API.menusId.eq(SysPlatformMenusRepoProc.QDO.id)});
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.constructor(MenusAndOperationNumVO.class, (Expression[])new Expression[]{QDO, apiNumExpr})).from((EntityPath)QDO)).where((Predicate)SysPlatformMenusRepoProc.QDO.menusAppCode.eq((Object)appCode).and((Predicate)SysPlatformMenusRepoProc.QDO.deleteFlag.eq((Object)0)))).fetch();
    }

    public List<MenusAndOperationNumVO> getMenusAndCountOperation(String appCode) {
        Expression apiNumExpr = (Expression)JPAExpressions.select((Expression)SysPlatformMenusRepoProc.QDO_MENU_OPERATION.id.count().as("apiNum")).from(new EntityPath[]{QDO_MENU_OPERATION}).where(new Predicate[]{SysPlatformMenusRepoProc.QDO_MENU_OPERATION.menusCode.eq((Expression)SysPlatformMenusRepoProc.QDO.menusCode).and((Predicate)((JPQLQuery)JPAExpressions.select((Expression)SysPlatformMenusRepoProc.QDO_OPERATION.id).from(new EntityPath[]{QDO_OPERATION}).where(new Predicate[]{SysPlatformMenusRepoProc.QDO_OPERATION.operationCode.eq((Expression)SysPlatformMenusRepoProc.QDO_MENU_OPERATION.operationCode)})).exists())});
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.constructor(MenusAndOperationNumVO.class, (Expression[])new Expression[]{QDO, apiNumExpr})).from((EntityPath)QDO)).where((Predicate)SysPlatformMenusRepoProc.QDO.menusAppCode.eq((Object)appCode).and((Predicate)SysPlatformMenusRepoProc.QDO.deleteFlag.eq((Object)0)))).fetch();
    }

    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue((Path)SysPlatformMenusRepoProc.QDO.menusAppCode, (Object)appCode);
    }

    public List<SysPlatformMenusDO> queryListMng(QueryMenusParam queryMenusParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)SysPlatformMenusRepoProc.QDO.menusAppCode, (Object)queryMenusParam.getAppCode()).andLike((StringExpression)SysPlatformMenusRepoProc.QDO.menusName, queryMenusParam.getMenusName()).andLike((StringExpression)SysPlatformMenusRepoProc.QDO.menusCode, queryMenusParam.getMenusCode()).and(queryMenusParam.getMenusType() != null, () -> SysPlatformMenusRepoProc.QDO.menusType.eq((Object)queryMenusParam.getMenusType().name())).andEq((SimpleExpression)SysPlatformMenusRepoProc.QDO.menusState, (Object)queryMenusParam.getMenusState()).andEq((SimpleExpression)SysPlatformMenusRepoProc.QDO.nodeType, (Object)queryMenusParam.getNodeType()).build();
        return super.getList(predicate, new OrderSpecifier[0]).stream().sorted(Comparator.comparing(SysPlatformMenusDO::getMenusOrder, Comparator.nullsFirst(Integer::compareTo).reversed())).collect(Collectors.toList());
    }

    public SysPlatformMenusDO getByMenusCode(@NotBlank String menusCode) {
        return (SysPlatformMenusDO)((Object)super.getOneByValue((Path)SysPlatformMenusRepoProc.QDO.menusCode, (Object)menusCode));
    }
}

