package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * 通用平台接口.
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@Api(tags = "通用接口")
@RestController
@RequestMapping(value = "/platform/common", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SysPlatformCommonController {

    @Autowired
    private SysPlatformAppService appService;

    @PostMapping("/queryApp")
    @ApiOperation(value = "分页查询应用")
    public ApiResult<PagingVO<SysPlatformAppVO>> queryApp(@RequestBody @Valid QueryAppParam queryAppParam) {
        return appService.queryByPage(queryAppParam);
    }
}
