package com.elitescloud.cloudt.platform.controller.api.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAreaService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 行政区域管理.
 *
 * @author Kaiser（wang shao）
 * 2023/1/10
 */
@Api(tags = "行政区域管理")
@RestController
@RequestMapping(value = "/platform/mng/area", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SysPlatformAreaController {

    private final SysPlatformAreaService sysPlatformAreaService;

    public SysPlatformAreaController(SysPlatformAreaService sysPlatformAreaService) {
        this.sysPlatformAreaService = sysPlatformAreaService;
    }

    @GetMapping(value = "/tree")
    @ApiOperation(value = "行政区域树")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParam(name = "tree", value = "是否返回树状，默认false", defaultValue = "false")
    public ApiResult<List<AreaMngTreeRespVO>> tree(@RequestParam(name = "tree", defaultValue = "false") Boolean tree) {
        return sysPlatformAreaService.tree(tree);
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存行政区域")
    @ApiOperationSupport(order = 2)
    public ApiResult<Long> save(@RequestBody @Valid PlatformAreaSaveVO saveVO) {
        return sysPlatformAreaService.save(saveVO);
    }

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "获取行政区域详情")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "区域ID", required = true)
    public ApiResult<AreaDetailRespVO> get(@PathVariable("id") Long id) {
        return sysPlatformAreaService.get(id);
    }

    @DeleteMapping(value = "/{id}")
    @ApiOperation(value = "删除行政区域详情")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "id", value = "区域ID", required = true)
    public ApiResult<Long> delete(@PathVariable("id") Long id) {
        return sysPlatformAreaService.delete(id);
    }

    @PutMapping(value = "/tree/rebuild")
    @ApiOperation(value = "重构行政区域树")
    @ApiOperationSupport(order = 5)
    public ApiResult<Boolean> treeRebuild() {
        return sysPlatformAreaService.execReBuildTree();
    }
}
