package com.elitescloud.cloudt.platform.model.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

/**
 * 菜单节点类型
 * **/
public enum PlatformAppTypeEnum {
    APP_TYPE_SYS("SYS_PLATFORM", "APP_TYPE", "APP类型", "系统",1),
    APP_TYPE_BUS("SYS_PLATFORM", "APP_TYPE", "APP类型", "业务",2),


    ;



    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformAppTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public String getDescription() {
        return description;
    }
}
