package com.elitescloud.cloudt.platform.model.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

/**
 * 菜单外连接类型
 * **/
public enum PlatformMenusOuterLinkTypeEnum {
    URL("SYS_PLATFORM", "PlatformMenusOuterLinkType", "URL", "URL链接",1),
    //Low-Code Development Platform
    LCDP("SYS_PLATFORM", "PlatformMenusOuterLinkType", "LCDP", "低代码开发平台",2),
    LCBP("SYS_PLATFORM", "PlatformMenusOuterLinkType", "LCBP", "低代码报表平台",3)
    ;


    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformMenusOuterLinkTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
}
