package com.elitescloud.cloudt.platform.model.constant;

import com.elitescloud.cloudt.system.vo.SysUdcVO;

/**
 * 请求类型
 **/
public enum PlatformRequestTypeEnum {
    POST("SYS_PLATFORM", "PlatformRequestType", "请求类型", "POST", 1),
    GET("SYS_PLATFORM", "PlatformRequestType", "请求类型", "GET", 2),
    PUT("SYS_PLATFORM", "PlatformRequestType", "请求类型", "PUT", 3),
    PATCH("SYS_PLATFORM", "PlatformRequestType", "请求类型", "PATCH", 4),
    DELETE("SYS_PLATFORM", "PlatformRequestType", "请求类型", "DELETE", 5),
    ;

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformRequestTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }
}
