package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity
@Table(name = TableNameConstant.SYS_PLATFORM_API_MANAGE, indexes = {
        @Index(name = "idx_api_app", columnList = "appCode"),
        @Index(name = "idx_api_code", columnList = "apiCode", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_API_MANAGE, comment = "接口管理")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_API_MANAGE, description = "接口管理")
public class SysPlatformApiManageDO extends BaseModel {

    @ApiModelProperty("接口所属应用")
    @Comment("接口所属应用")
    @Column(nullable = false)
    String appCode;

    @ApiModelProperty("接口名称")
    @Comment("接口名称")
    @Column(nullable = false)
    String apiName;

    @ApiModelProperty("接口编号")
    @Comment("接口编号")
    @Column(nullable = false)
    String apiCode;

    @ApiModelProperty("请求类型 POST,GET,PUT,DELETE")
    @Comment("请求类型")
    @Column
    String requestType;

    @ApiModelProperty("请求路径")
    @Comment("请求路径")
    @Column(nullable = false)
    String apiPath;

    @ApiModelProperty("接口描述")
    @Comment("接口描述")
    @Column
    String apiDescribe;
}
