package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


@Entity
@Table(name = TableNameConstant.SYS_PLATFORM_MENUS_API)
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_MENUS_API, comment = "菜单接口")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_MENUS_API, description = "菜单接口")
public class SysPlatformMenusApiDO extends BaseModel {

    @ApiModelProperty("应用id")
    @Comment("应用id")
    @Column(nullable = false)
    Long appId;

    @ApiModelProperty("应用编码")
    @Comment("应用编码")
    @Column(nullable = false)
    String appCode;

    @ApiModelProperty("菜单id")
    @Comment("菜单id")
    @Column(nullable = false)
    Long menusId;

    @Comment("菜单编码")
    @Column(nullable = false)
    String menusCode;

    @ApiModelProperty("接口id")
    @Comment("接口id")
    @Column(nullable = false)
    Long apiId;
}
