package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.util.Objects;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Entity
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_MENUS, comment = "平台菜单表")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value =  TableNameConstant.SYS_PLATFORM_MENUS, description = "平台菜单表")
@Table(name =  TableNameConstant.SYS_PLATFORM_MENUS, indexes = {
        @Index(name = "idx_menu_code", columnList = "menusCode", unique = true)
})
public class SysPlatformMenusDO extends BaseModel {
    @ApiModelProperty("菜单归属应用")
    @Comment("菜单归属应用")
    @Column
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    @Comment("菜单名称")
    @Column
    String menusName;

    @ApiModelProperty("菜单类型 业务,系统")
    @Comment("菜单类型")
    @Column
    String menusType;

    @ApiModelProperty("节点类型 菜单,按钮")
    @Comment("节点类型")
    @Column
    String nodeType;

    @ApiModelProperty("菜单编码")
    @Comment("菜单编码")
    @Column
    String menusCode;

    @ApiModelProperty("排序")
    @Comment("排序")
    @Column()
    Integer menusOrder;

    @ApiModelProperty("菜单状态")
    @Comment("菜单状态")
    @Column()
    Boolean menusState;

    @ApiModelProperty("上级菜单编码")
    @Comment("上级菜单编码")
    @Column
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    @Comment("菜单路由")
    @Column
    String menusRoute;

    @ApiModelProperty("描述")
    @Comment("描述")
    @Column
    String menusDescribe;

    @ApiModelProperty("图标")
    @Comment("图标")
    @Column
    String menusIcon;

    @ApiModelProperty("是否展示")
    @Comment("是否展示")
    @Column()
    Boolean display;

    @ApiModelProperty("是否外链接")
    @Comment("是否外链接")
    @Column()
    Boolean outerLink;
    @ApiModelProperty("外链接类型")
    @Comment("外链接类型")
    @Column()
    @Enumerated(EnumType.STRING)
    PlatformMenusOuterLinkTypeEnum outerLinkType;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformMenusDO that = (SysPlatformMenusDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
