package com.elitescloud.cloudt.platform.model.entity;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * 平台应用udc
 */
@Entity
@Table(name = "sys_platform_udc"
        ,uniqueConstraints = @UniqueConstraint(columnNames= {"appCode","udcCode", "tenantId"})
)
@org.hibernate.annotations.Table(appliesTo = "sys_platform_udc", comment = "平台应用udc")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = "sys_platform_udc", description = "平台应用udc")
public class SysPlatformUdcDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 2101175752025256218L;
    @ApiModelProperty("应用编码")
    @Comment("应用编码")
    @Column()
    private String appCode;

    @ApiModelProperty("编码")
    @Comment("编码")
    @Column()
    private String udcCode;

    @ApiModelProperty("名称")
    @Comment("名称")
    @Column()
    private String udcName;

    @ApiModelProperty("允许编辑")
    @Comment(value = "允许编辑", defaultValue = "1")
    @Column(name = "allow_update")
    private Boolean allowUpdate;

    @ApiModelProperty("允许新增值")
    @Comment(value = "允许新增值", defaultValue = "1")
    @Column(name = "allow_add_value")
    private Boolean allowAddValue;

    @ApiModelProperty("描述")
    @Comment("描述")
    @Column()
    private String udcDescribe;

    @Comment("上级UDC编码")
    @Column()
    private String parentUdcCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformUdcDO that = (SysPlatformUdcDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}

