package com.elitescloud.cloudt.platform.model.params.api;

import com.elitescloud.cloudt.platform.model.constant.PlatformApiFieldTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class ApiFieldParam implements Serializable {

    @ApiModelProperty(value = "字段名称", required = true)
    @NotBlank
    String fieldName;

    @ApiModelProperty(value = "字段类型", required = true)
    @NotBlank
    PlatformApiFieldTypeEnum fieldType;

    @ApiModelProperty(value = "字段是否可以为空", required = true)
    @NotBlank
    Boolean fieldIsNull;

    @ApiModelProperty("字段说明")
    String fieldExplain;

    @ApiModelProperty("备注描述")
    String remark;
}
