package com.elitescloud.cloudt.platform.model.params.seq;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 发号器规则VO
 *
 * @author Michael Li
 * 2020-10-11
 */
@Data
@ApiModel("发号器规则VO")
public class SysPlatformNumberRuleAddParam implements Serializable {
    private static final long serialVersionUID = 2516122099027482881L;

    @ApiModelProperty(value = "应用编码")
    private  String appCode;
    /**
     * ID
     */
    @ApiModelProperty("唯一编号ID")
    private Long id;

    /**
     * 规则编码
     */
    @ApiModelProperty("规则编码")
    @NotBlank(message = "规则编码为空")
    private String ruleCode;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称")
    @NotBlank(message = "规则名称为空")
    private String ruleName;

    /**
     * 是否启用
     */
    @ApiModelProperty("是否启用")
    private Boolean enabled;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 取号示例
     */
    @ApiModelProperty(value = "取号示例")
    private String sampleCode;
}
