package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.cloudt.platform.model.constant.PlatformApiFieldTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SysPlatformApiParameterVO implements Serializable {

    @ApiModelProperty("id")
    Long id;

    @ApiModelProperty("字段所属接口id")
    Long apiId;

    @ApiModelProperty("字段所属接口编码")
    String apiCode;

    @ApiModelProperty("字段名称")
    String fieldName;

    @ApiModelProperty("字段类型")
    PlatformApiFieldTypeEnum fieldType;

    public String getFieldTypeName() {
        return fieldType != null ? fieldType.getDescription() : null;
    }

    @ApiModelProperty("字段是否可以为空")
    Boolean fieldIsNull;

    @ApiModelProperty("字段说明")
    String fieldExplain;

    @ApiModelProperty("备注描述")
    String remark;
}
