package com.elitescloud.cloudt.platform.model.vo.sequence;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 下一编号.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "下一编号")
public class SysPlatformSeqNumRespVO implements Serializable {
    private static final long serialVersionUID = 8059960769559891887L;
    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 0)
    private String appCode;
    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码", position = 2)
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称", position = 3)
    private String name;


    @ApiModelProperty(value = "下一编号步长")
    @NotNull
    Integer step;

    @ApiModelProperty(value = "下一编号取值")
    @NotNull
    Long nextNumber;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 7)
    private Boolean enabled;
    /**
     * 是否系统内置
     */
    @ApiModelProperty(value = "是否系统内置", position = 6)
    private Boolean internal;

    @ApiModelProperty(value = "下一编号周期[UDC]SYS:NNPERIOD")
    String nnPeriod;
}
