package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.params.menus.*;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.MenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
public interface SysPlatformMenusService {
    ApiResult<Long> addMenus(AddMenusParam addMenusParam);

    ApiResult<Long> addButton(AddButtonParam addButtonParam);

    ApiResult<Boolean> updateMenus(Long id, UpdateMenusParam updateMenusParam);

    ApiResult<Boolean> updateButton(Long id, UpdateButtonParam updateMenusParam);

    ApiResult<Boolean> deleteFlagMenus(Long id);

    ApiResult<Boolean> updateMenusState(Long id, Boolean state);

    ApiResult<SysPlatformMenusVO> getMenus(Long id);

    ApiResult<List<SysPlatformMenusVO>> queryMenus(QueryMenusParam queryMenusParam);

    ApiResult<List<SysUdcVO>> getMenusTypeEnum();


    ApiResult<Long> addMenusGroup(AddMenusParam addMenusParam);

    ApiResult<Boolean> updateMenusGroup(Long id, UpdateMenusParam updateMenusParam);


    /**
     * 查询 应用信息和 菜单信息 只能查询系统类型或业务类型
     **/
    ApiResult<GetAppMenusVO> getSysBusAppMenus(PlatformAppMenusTypeEnum platformAppMenusTypeEnum);

    /**
     * 查询全部类型应用和菜单
     **/
    ApiResult<GetAppMenusVO> getAllAppMenus();

    ApiResult<GetAppMenusVO> getSysAppMenusAll(PlatformAppMenusTypeEnum menusTypeSys);

    ApiResult<Boolean> deleteMenus(Long id);

    ApiResult<Long> addFormMenus(AddFormMenusParam addMenusParam);

    ApiResult<Boolean> updateFormMenus(Long id, UpdateFormMenusParam updateMenusParam);

    ApiResult<List<SysUdcVO>> getPlatformMenusOuterLinkTypeEnum();

    ApiResult<List<SysPlatformMenusApiVO>> getAllAppMenusApi(String appCode);

    ApiResult<Boolean> addMenusApi(AddMenusApiParam addMenusApiParam);

    ApiResult<Boolean> deleteMenusApi(DeleteMenusApiParam deleteMenusApiParam);

    ApiResult<List<MenusApiVO>> getMenusApis(Long appId, Long menusId);
}
