package com.elitescloud.cloudt.platform.service.repo;



import com.elitescloud.cloudt.platform.model.entity.SysPlatformAppDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @Description:  平台应用管理
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Repository
public interface SysPlatformAppRepo extends JpaRepository<SysPlatformAppDO, Long>,
        QuerydslPredicateExecutor<SysPlatformAppDO> {

     List<SysPlatformAppDO> findByAppCode(String appCode);
     List<SysPlatformAppDO> findByAppCodeIn(List<String> appCode);

     List<SysPlatformAppDO> findByAppTypeAndAppState(String appType, Boolean appState);
     List<SysPlatformAppDO> findByAppType(String appType);
 }
