package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

@Repository
public class SysPlatformMenusApiRepoProc extends BaseRepoProc<SysPlatformMenusApiDO> {
    private static final QSysPlatformMenusApiDO QDO = QSysPlatformMenusApiDO.sysPlatformMenusApiDO;

    public SysPlatformMenusApiRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }

    /**
     * 根据菜单编码删除
     *
     * @param menuCode 菜单编码
     */
    public void deleteByMenuCode(@NotBlank String menuCode) {
        super.deleteByValue(QDO.menusCode, menuCode);
    }
}
